%This file is a test suite for the function gausselimfp.  We will test
%its speed and accuracy compared to the Matlab function rref and solver A\b

%Start off with a clean slate
clear all
clf

%Test the different methods with random matricies of these dimensions.
%(Note that big dimensions => :( CPU)
dimensions=[10 50 100];% 200 500 1000];
%Number of solves to average over per dimension
repetitions=10;

fptime=zeros(1,size(dimensions,2));
fperror=fptime;
rreftime=fptime;
rreferror=fptime;
bstime=fptime;
bserror=fptime;

%Here we basically just run each of the three algorithms, record and
%average how long each takes to run, and record and average how much error
%each generates.
parfor i=1:size(dimensions,2)
    for j=1:repetitions
        %Our randomly-generated matricies
        A=100*(rand(dimensions(i),dimensions(i))-0.5);
        b=100*(rand(dimensions(i),1)-0.5);
        %And the three tests
        tic
        fptemp=gausselimfp(A,b);
        fptime(1,i)=fptime(1,i)*(j-1)/j+toc/j;
        tic
        rreftemp2=rref([A b]);
        rreftemp=rreftemp2(:,end);
        rreftime(1,i)=rreftime(1,i)*(j-1)/j+toc/j;
        tic
        bstemp=A\b;
        bstime(1,i)=bstime(1,i)*(j-1)/j+toc/j;
        fperror(1,i)=fperror(1,i)*(j-1)/j+norm(A*fptemp-b);
        rreferror(1,i)=rreferror(1,i)*(j-1)/j+norm(A*rreftemp-b);
        bserror(1,i)=bserror(1,i)*(j-1)/j+norm(A*bstemp-b);
    end
end

%And finally we plot everything
subplot(1,2,1)
semilogy(dimensions,fptime)
hold on
semilogy(dimensions,rreftime,'g')
semilogy(dimensions,bstime,'r')
legend('Full Pivot','rref','Matlab Solver')
xlabel('Dimension')
ylabel('Time (sec)')
title('Speed')
subplot(1,2,2)
semilogy(dimensions,fperror)
hold on
semilogy(dimensions,rreferror,'g')
semilogy(dimensions,bserror,'r')
legend('Full Pivot','rref','Matlab Solver')
xlabel('Dimension')
ylabel('Error w.r.t. True Solution (Euclidian norm)')
title('Accuracy')